%%% demo.m  Small demonstration of color vision
% by Chuck DiMarzio, Northeastern University
% at Universidad de los Andes  
% Santiago, Chile
% 1 June 2015

data=load('x.ind');
x=data(:,2);
data=load('y.ind');
y=data(:,2);
data=load('z.ind');
z=data(:,2);
lambda=data(:,1);


M_eye=[x,y,z]';
figure;imagesc(lambda,1:3,M_eye);colorbar;
xlabel('lambda, microns');title('Meye');

% A small test cube.
data=zeros(2,3,length(lambda));
data(1,1,:)=double(lambda>0.6);
data(1,2,:)=1;
data(1,3,:)=double((lambda>0.50)&(lambda<0.57));
data(2,1,:)=lambda.*double(lambda<0.48);
data(2,2,:)=0;
data(2,3,:)=double(lambda>0.48);

% temp cube looks like
% Red Black Green
% Blue White Yellow
data=zeros(2,3,length(lambda));
data(1,1,:)=double(lambda>0.64&lambda<0.7)*5;
data(1,2,:)=0;
data(1,3,:)=double(lambda>0.52&lambda<0.56);
data(2,1,:)=double(lambda>0.40&lambda<0.46);
data(2,2,:)=1;
data(2,3,:)=double(lambda>0.52&lambda<0.66);


%hsi4(data,lambda*1000,[-0.2,1.2]);

pdata=reshape(data,size(data,1)*size(data,2),size(data,3))';
figure;imagesc(1:6,lambda,pdata);colorbar;title('pdata');

pcube=M_eye*pdata;
figure;imagesc(pcube);colorbar;title('pcube');

cube=reshape(pcube',[size(data(:,:,1)),3]);
cube



rgbcube=xyz2rgb(cube);
rgbcube=max(0,rgbcube/max(rgbcube(:)));figure;image(rgbcube);
title('RGB');
rgbcube


