function h=hsi4(data,wavel,limits,optname);
% function h=hsi4(data,wavel,hilimit);
% function h=hsi4(data,wavel,[lolimit,hilimit]);
%
% Tue Aug 13 19:13:27 2013
% from file hsi3.m by Chuck DiMarzio and Manda Kashambala
%                Northeastern University, December 00
%
% data is a data cube with dimensions x,y,wavelength
% wavel is a vector of wavelengths
% lolimit if specified is lower data amplitude limit
% hilimit is the upper data amplitude limit 
%            for plots and colorbars
% 
% Click in the lower right plot area to stop.
%
rev='1.03'
%
% rev 1.03 corrects rounding on xi, yi, wselect from ginput
%
if(length(limits)==1);lolimit=0;hilimit=limits;
else;
  lolimit=limits(1);hilimit=limits(2);
end;
if(exist('optname','var'));name=optname;else;name='';end;
irun=1;
h=figure;
loops=0;
% Following are subplot position parameters
left1=0.05;right1=0.55; % left edge of plot for left and right columns
top2=0.55;bot2=0.05; % bottom edge of plot for top and bottom rows
pos3=0.35;pos4=0.35; % Width and height of subplots
% interactive slices of the data cube
% data is a data cube
% wavel is a list of wavelengths
wavels=length(wavel);
rows=size(data,2);
cols=size(data,1);
coltix=1:cols;
rowtix=1:rows;
wi=floor(wavels/2);
while(irun==1);
   himage=subplot('Position',[left1,top2,pos3,pos4]);
   imagesc(coltix,rowtix,data(:,:,wi)');
   set(gca,'xdir','reverse'); set(gca,'ydir','normal');
   axis image;caxis([lolimit,hilimit]);
   xlabel('x');ylabel('y');
   title(strcat(name,' \lambda_{',...
      num2str(wi),'} = ',num2str(wavel(wi))));
   
   if(loops<1);
   	[xi,yi]=ginput(1);
		xi=floor(xi);yi=floor(yi);
   end;
   loops=loops+1;
   
      hold on
   plot([xi,xi],[1,size(data,2)],'w');
   plot([1,size(data,1)],[yi,yi],'w');
   hold off
   
   hcolumn=subplot('Position',[right1,top2,pos3,pos4]);
   imagesc(wavel,rowtix,squeeze(data(xi,:,:)));
	set(gca,'ydir','normal');
	caxis([lolimit,hilimit]);
	xlabel('\lambda, Wavelength, nm');
	ylabel('y');
   title(strcat('column',num2str(xi)));
   hold on;
   plot([wavel(1),wavel(length(wavel))],[yi,yi],'w');
   plot([wavel(wi),wavel(wi)],[1,size(data,2)],'w');
   hold off;
    
   hrow=subplot('Position',[left1,bot2,pos3,pos4]);
   imagesc(coltix,wavel,squeeze(data(:,yi,:))');
   set(gca,'xdir','reverse');caxis([lolimit,hilimit]);
   title(strcat('row',num2str(yi)));
   hold on;
   plot([xi,xi],[wavel(1),wavel(length(wavel))],'w');
   plot([1,size(data,1)],[wavel(wi),wavel(wi)],'w');
   hold off;
  
	hpixel=subplot('Position',[right1,bot2,pos3,pos4]);
   plot(wavel,squeeze(data(xi,yi,:)));grid on;
   axis([wavel(1),wavel(length(wavel)),lolimit,hilimit]);
	xlabel('\lambda, Wavelength, nm');
	title(strcat('column',num2str(xi),', row',num2str(yi)));
        caxis([lolimit,hilimit]);colorbar;
	[ai,bi]=ginput(1);
	
	h1=gca;
   if(h1==hcolumn);
      wselect=floor(ai+1.5);yi=floor(bi+0.5);disp('column');
      if(wselect<wavel(1));
         wi=1;
      else;
         wtest=find(wavel<wselect);
      end;
      wi=wtest(length(wtest));
   end;

if(h1==hrow);
   xi=floor(ai+0.5);wselect=floor(bi+1.5);disp('row');
      if(wselect<=wavel(1));
         wi=1;
      else;
         wtest=find(wavel<wselect);
      end;
      wi=wtest(length(wtest));
end;

	if(h1==himage);xi=floor(ai+0.5);yi=floor(bi+0.5);disp('image');end;

	if(h1==hpixel);irun=0;end;

	disp(strcat('xi=',num2str(xi),', yi=',num2str(yi),', wi=',num2str(wi)));
end;

